<?php
/*
 * No direct access to this file
 */
if (! isset($data)) {
	exit;
}
?>
<div class="wpacu-video-areas">
    <div class="wpacu-video-area-wrapper">
        <div class="wpacu-col-left wpacu-video-wrapper">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/ATXACFtcyKs?start=441" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
        <div class="wpacu-col-right">
            <p>If you are using heavy themes such as Avada, visual builders like Divi, Elementor, Beaver Builder  or anything else that causes bloat, this tutorial will teach you optimizations which will significantly speed up ANY WordPress website. <strong><em>At ~07:21 within the video, the stripping of the "fat" topic is brought, followed by the setup of Asset CleanUp.</em></strong></p>
            <p>There are three main thing that typically degrade performance and make a WordPress website run slowly. Fix these, and you'll have a fast loading website:</p>
            <ol>
                <li>Plugins (and WordPress core) loads scripts and styles onto all pages of your site, even when they only need to be present on a single page.</li>
                <li>Excessively large files (like images) are being loaded on the page - resulting in slow load times. Compress these files to speed things up.</li>
                <li>Bad web hosting providers don't deliver your page to the visitor quickly - resulting in slow load times even for a lightweight page.</li>
            </ol>
        </div>
    </div>

    <div class="wpacu-video-area-wrapper">
        <div class="wpacu-col-left wpacu-video-wrapper">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/B8_QLVAgQiU" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
        <div class="wpacu-col-right">
            <p>This is a video tutorial explaining how to improve the loading speed of your WordPress blog or any specific page on your blog through the Asset CleanUp WordPress Plugin.</p>
            <p>Google PageSpeed Insights is used to analyze the page load and the following improvements were achieved just by stripping the "fat":</p>
            <ul>
                <li><strong>17</strong>/100 to <strong>27</strong>/100 for Mobile</li>
                <li><strong>61</strong>/100 to <strong>81</strong>/100 for Desktop</li>
            </ul>
        </div>
    </div>

    <div class="wpacu-video-area-wrapper">
        <div class="wpacu-col-left wpacu-video-wrapper">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/zDix8THVpA8?start=845" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
        <div class="wpacu-col-right">
            <p>This video from WPCasts, shows how to use Asset CleanUp to reduce the number of HTTP requests and the MB transferred.</p>
            <p><strong>At ~14:05 within the video, Asset CleanUp comes into play.</strong></p>
        </div>
    </div>

    <div class="wpacu-video-area-wrapper">
        <div class="wpacu-col-left wpacu-video-wrapper">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/fbwczibhNqQ" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
        <div class="wpacu-col-right">
            <p>This video from "Acabado Theme Customization", shows how Asset CleanUp can help you increase your loading times for your visitors without a bunch of effort, it just takes some time and patience to learn and you can increase scores and speed dramatically.</p>
            <p>It involves an increase of speed from <strong>76</strong>/100 via Mobile in Google PageSpeed Insights to <strong>99</strong>/100 by optimizing the homepage which should not load so many useless CSS &amp; JavaScript files.</p>
        </div>
    </div>

    <div class="wpacu-video-area-wrapper">
        <div class="wpacu-col-left wpacu-video-wrapper">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/5By-lvZPENU?start=1120" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
        <div class="wpacu-col-right">
            <p>This video from "NodeFlame Labs" is about speeding up your web pages and <strong>starts showing how to use the plugin and dequeue unused scripts &amp; styles at ~18:40</strong>.</p>
            <p>It involves an increase of speed from <strong>71</strong>/100 via Mobile in Google PageSpeed Insights to <strong>78</strong>/100 by unloading a bunch of unnecessary CSS/JS files.</p>
        </div>
    </div>

    <div class="wpacu-video-area-wrapper">
        <div class="wpacu-col-left wpacu-video-wrapper">
            <a target="_blank" href="https://www.youtube.com/watch?v=garf1tL6PTU&start=1925"><img src="<?php echo esc_url(WPACU_PLUGIN_URL); ?>/assets/images/sproutedweb-asset-cleanup-elementor-video.jpg" style="width: 560px;" alt="" /></a>
        </div>
        <div class="wpacu-col-right">
            <p>This video from SproutedWeb, covers some basic Performance Fundamentals, shows the latest Benchmarks for Elementor v2.5.3 (on WP Engine, PHP 7.2, WP 5.1).</p>
            <p>They also cover the basics of how to read a Waterfall Chart, and how to trim a lot of the fat on Elementor pages.</p>
            <p><strong>At ~32:05 within the video, Asset CleanUp comes into play.</strong></p>
        </div>
    </div>

    <div class="wpacu-video-area-wrapper">
        <div class="wpacu-col-left wpacu-video-wrapper">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/FiYYtr-9jGA" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
        <div class="wpacu-col-right">
            <p><strong><span class="dashicons dashicons-info"></span> This video is for Portuguese speakers.</strong></p>
            <p>Veja Outras dicas de Performance WordPress para deixar o seu site ainda mais rápido.</p>
            <p>Tutorial: <a target="_blank" href="https://blog.escolaninjawp.com.br/performance-wordpress/">https://blog.escolaninjawp.com.br/performance-wordpress/</a></p>
        </div>
    </div>
</div>