<?php
/**
 * Template part for displaying a post's content
 *
 * @package kadence
 */

namespace Kadence;

?>

<div class="<?php echo esc_attr( apply_filters( 'kadence_entry_content_class', 'entry-content single-content' ) ); ?>">
	<?php
	do_action( 'kadence_single_before_entry_content' );
	
	echo '<p style="font-size: 16px; line-height: 13px; text-align: center;">*<i>This post may contain affiliate links for which I earn commissions.</i>*<br/><br/><br/></p>';

		if( get_field('htp_image_for_pinterest') ): 
	                    echo '<img src="';
                            echo get_field('htp_image_for_pinterest');
                            echo '" style="width: 300px; padding-right: 10px; padding-bottom: 20px; float: left;" alt="';
                            echo the_title();
                            echo '">';
                            endif;                           
                            echo get_field('htp_intro');
                            echo '<br/><br/>';
                            echo '<p style="clear: both"></p>';
                            echo get_field('htp_video');
                            echo '<br/>';
			                if( get_field('htp_own_image_1_content') ):
                            echo get_field('htp_own_image_1_content');
                            endif;
			                if( get_field('htp_own_image_1') ):
                            echo '<img src="';
                            echo get_field('htp_own_image_1');
                            echo '" style="width: 100%; padding-left: 10px; padding-right: 10px; padding-bottom; 20px;" alt="';
                            echo get_field('htp_own_image_1_alt_tag');
                            echo '">';
			                echo '<br/>';
                            endif;
                            echo '<h2>Supplies Needed</h2>';
                            echo '<span style="display: block; width: 90%; float: right;">';
                            if( get_field('htp_supply_1_retailer') == 'Amazon' )
                            {echo '<a rel="nofollow" href="https://www.amazon.com/dp/';
                            echo str_replace(' ', '', get_field('htp_supply_1_asin'));
                            echo '/?tag=';
                            echo get_field('htp_tracking_id_1');
                            echo '">';
                            echo get_field('htp_supply_1_name');
                            echo '</a><br/><br/>';}
                            else {echo '<a rel="nofollow" href="';
                            echo str_replace(' ', '', get_field('htp_supply_1_affiliate_link'));
                            echo '">';
                            echo get_field('htp_supply_1_name');
                            echo '</a><br/><br/>';} 
                            if( get_field('htp_supply_2_retailer') == 'Amazon' )
                            {echo '<a rel="nofollow" href="https://www.amazon.com/dp/';
                            echo str_replace(' ', '', get_field('htp_supply_2_asin'));
                            echo '/?tag=';
                            echo get_field('htp_tracking_id_2');
                            echo '">';
                            echo get_field('htp_supply_2_name');
                            echo '</a><br/><br/>';}
                            else {echo '<a rel="nofollow" href="';
                            echo str_replace(' ', '', get_field('htp_supply_2_affiliate_link'));
                            echo '">';
                            echo get_field('htp_supply_2_name');
                            echo '</a><br/><br/>';}
                            echo get_field('htp_remaining_supplies');
                            echo '</span>';
                            echo '<p style="clear: both"></p><br/>';
                            echo '<h2>Step by Step Instructions</h2>';
                            echo '<span style="display: block; width: 90%; float: right;">';
                            echo get_field('htp_instructions');
                            echo '</span><br/><br/>';
                            echo '<p style="clear: both"></p><br/>';
                            echo get_field('htp_summary');
    (
		sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'kadence' ),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			),
			get_the_title()
		)
	);

	wp_link_pages(
		array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'kadence' ),
			'after'  => '</div>',
		)
	);
	do_action( 'kadence_single_after_entry_content', 'spoke_post');
	?>
</div><!-- .entry-content -->